import {createReducer, ActionType} from 'typesafe-actions';

import IStateBugReporter from '../interfaces/state/bugReporter/IStateBugReporter';
import BugType from '../interfaces/state/bugReporter/BugType';

import * as actions from '../actions/bugReporter';

type Actions = ActionType<typeof actions>;

const DEFAULT_STATE: IStateBugReporter = {
    formIsOpened: false,
    bugType: BugType.interfaceBug,
    title: '',
    description: '',
    reportSending: false,
    reportIsSent: null,
};

export default createReducer<IStateBugReporter, Actions>(DEFAULT_STATE)
    .handleAction(actions.setReportSending, (state, {payload}) => ({
        ...state,
        reportSending: payload,
        reportIsSent: null,
    }))
    .handleAction(actions.setSendStatus, (state, {payload}) => ({
        ...(payload ? DEFAULT_STATE : state),
        reportIsSent: payload,
        reportSending: false,
        formIsOpened: state.formIsOpened,
    }))
    .handleAction(actions.setBugType, (state, {payload}) => ({
        ...state,
        bugType: payload,
    }))
    .handleAction(actions.setTitle, (state, {payload}) => ({
        ...state,
        title: payload,
    }))
    .handleAction(actions.setDescription, (state, {payload}) => ({
        ...state,
        description: payload,
    }))
    .handleAction(actions.setFormIsOpened, (state, {payload}) => ({
        ...(payload === false && state.reportIsSent === true
            ? DEFAULT_STATE
            : state),
        formIsOpened: payload,
    }));
