import {SET_NATIONAL_VERSION} from '../actions/nationalVersion';

import {
    SET_PREFERRED_CURRENCY,
    SET_CURRENCY_RATES,
    SET_AVAILABLE_CURRENCIES,
} from '../actions/currencies';

import CurrencyCode from '../interfaces/CurrencyCode';

import getNationalCurrency from '../lib/currencies/getNationalCurrency';

const DEFAULT_STATE = {
    nationalCurrency: CurrencyCode.rub,
    preferredCurrency: CurrencyCode.rub,
    availableCurrencies: [],
    currencyRates: {},
};

export default function currencies(state = DEFAULT_STATE, {type, payload}) {
    switch (type) {
        case SET_NATIONAL_VERSION: {
            const nationalCurrency = getNationalCurrency(payload);

            return {
                ...state,
                nationalCurrency,
                preferredCurrency: nationalCurrency,
            };
        }

        case SET_PREFERRED_CURRENCY:
            return {
                ...state,
                preferredCurrency: payload,
            };
        case SET_AVAILABLE_CURRENCIES:
            return {
                ...state,
                availableCurrencies: payload,
            };
        case SET_CURRENCY_RATES:
            return {
                ...state,
                currencyRates: {
                    ...state.currencyRates,
                    ...payload,
                },
            };

        default:
            return state;
    }
}
