import {createReducer, ActionType} from 'typesafe-actions';

import IStateHome from '../interfaces/state/IStateHome';

import * as actions from '../actions/home';

type Actions = ActionType<typeof actions>;

const defaultState: IStateHome = {
    blablacarLink: {
        url: undefined,
        banned: false,
    },
    isCity: false,
    isOpenedBusCollapse: false,
    isOpenedTrainCollapse: false,
};

export default createReducer<IStateHome, Actions>(defaultState)
    .handleAction(actions.setDataForFetchingPage, () => defaultState)
    .handleAction(actions.setBlablacarLink, (state, {payload}) => ({
        ...state,
        blablacarLink: payload,
    }))
    .handleAction(actions.setIsCity, (state, {payload}) => ({
        ...state,
        isCity: payload,
    }))
    .handleAction(actions.setIsOpenedBusCollapse, (state, {payload}) => ({
        ...state,
        isOpenedBusCollapse: payload,
    }))
    .handleAction(actions.setIsOpenedTrainCollapse, (state, {payload}) => ({
        ...state,
        isOpenedTrainCollapse: payload,
    }));
