import {createReducer, ActionType} from 'typesafe-actions';

import IStateInfo from '../interfaces/state/info/IStateInfo';

import * as actions from '../actions/info';

type Actions = ActionType<typeof actions>;

const defaultState: IStateInfo = {
    id: 0,
    slug: undefined,
    title: '',
    content: '',
    metaDescription: '',
    metaTitle: '',
    children: [],
    parents: [],
};

export default createReducer<IStateInfo, Actions>(defaultState)
    .handleAction(actions.setDataForFetchingPage, () => ({...defaultState}))
    .handleAction(actions.setDataFromAPI, (state, {payload}) => ({
        ...state,
        ...payload,
    }));
