import {
    START_FETCHING_PAGE,
    FINISH_FETCHING_PAGE,
    SET_LEAVING_PAGE,
    SET_ORIGIN_URL,
    SET_FULL_URL,
    SET_LOCATION,
} from '../actions/page';

const defaultState = {
    location: {
        pathname: '',
        query: {},
    },
    leaving: false,
    current: null,
    fetching: null,
    originUrl: '',
    fullUrl: '',
    prevPage: null,
};

export default function page(state = defaultState, {type, payload}) {
    switch (type) {
        case SET_LEAVING_PAGE:
            return {
                ...state,
                leaving: payload,
            };
        case START_FETCHING_PAGE:
            return {
                ...state,
                fetching: payload,
                prevPage:
                    payload !== state.current && payload
                        ? state.current
                        : state.prevPage,
            };
        case FINISH_FETCHING_PAGE:
            return {
                ...state,
                fetching: null,
                current: payload,
            };
        case SET_ORIGIN_URL:
            return {
                ...state,
                originUrl: payload,
            };
        case SET_FULL_URL:
            return {
                ...state,
                fullUrl: payload,
            };
        case SET_LOCATION:
            return {
                ...state,
                location: payload,
            };

        default:
            return state;
    }
}
