import {SET_SAMPLE_SEARCH_CONTEXT} from '../actions/sampleSearchContext';
import {
    SET_SEARCH_HISTORY,
    ADD_ITEM_TO_SEARCH_HISTORY,
    FAVORITE_SEARCH_HISTORY_ITEM,
} from '../actions/searchHistory';

import {
    addItemToSearchHistory,
    favoriteSearchHistoryItem,
} from '../lib/searchHistory/searchHistoryManager';

const defaultState = {
    sampleSearchContext: null,
    searchHistory: [],
};

function addItem(state, {from, to}) {
    return {
        ...state,
        searchHistory: addItemToSearchHistory(state.searchHistory, {from, to}),
    };
}

function setFavorite(state, {searchContext, favorite}) {
    const {from, to} = searchContext;

    return {
        ...state,
        searchHistory: favoriteSearchHistoryItem(
            state.searchHistory,
            {from, to},
            favorite,
        ),
    };
}

export default function searchFormHints(state = defaultState, {type, payload}) {
    switch (type) {
        case SET_SAMPLE_SEARCH_CONTEXT:
            return {
                ...state,
                sampleSearchContext: payload,
            };
        case SET_SEARCH_HISTORY:
            return {
                ...state,
                searchHistory: payload,
            };
        case ADD_ITEM_TO_SEARCH_HISTORY:
            return addItem(state, payload);
        case FAVORITE_SEARCH_HISTORY_ITEM:
            return setFavorite(state, payload);

        default:
            return state;
    }
}
