import {
    SET_TOOLTIP_CONTENT,
    SET_TOOLTIP_POSITION,
    SET_TOOLTIP_VISIBILITY,
} from '../actions/tooltip';

const DEFAULT_STATE = {
    content: null,
    visible: false,
    position: {
        top: 0,
        left: 0,
    },
};

export default function (state = DEFAULT_STATE, {type, payload}) {
    switch (type) {
        case SET_TOOLTIP_CONTENT:
            return {
                ...state,
                content: payload,
            };
        case SET_TOOLTIP_POSITION:
            return {
                ...state,
                position: payload,
            };
        case SET_TOOLTIP_VISIBILITY:
            return {
                ...state,
                visible: payload,
            };

        default:
            return state;
    }
}
