import {
    SET_DATA_FROM_API,
    SET_DATA_FOR_FETCHING_PAGE,
} from '../actions/transport';

import {makeReducer} from '../lib/reduxUtils';

import {
    getDataOfStation,
    getDataOfArticle,
    getDataOfPopularDirection,
} from './transportPages';

const defaultState = {
    transportType: '',
    mainCity: {
        title: '',
        titleGenitive: '',
        slug: '',
        stations: [],
    },
    cities: [],
    articles: [],
    countries: [],
    secondaryCity: {
        title: '',
        titleGenitive: '',
        slug: '',
        stations: [],
    },
    popularDirections: [],
};

const setTransportType = (state, payload) => ({
    ...state,
    transportType: payload || defaultState.transportType,
});

const setStations = payload => {
    return Array.isArray(payload)
        ? payload.map(getDataOfStation).filter(Boolean)
        : defaultState.mainCity.stations;
};

const getMainCityData = ({slug, title, stations, titleGenitive}) => {
    if (!title || !slug || !stations.length) {
        return null;
    }

    return {
        slug,
        title,
        stations: setStations(stations),
        titleGenitive: titleGenitive || defaultState.mainCity.titleGenitive,
    };
};

const setMainCity = (state, payload) => {
    const mainCity = getMainCityData(payload);

    return {
        ...state,
        mainCity: mainCity || defaultState.mainCity,
    };
};

const setArticles = (state, payload) => ({
    ...state,
    articles: Array.isArray(payload)
        ? payload.map(getDataOfArticle).filter(Boolean)
        : defaultState.articles,
});

const getDataOfCountry = ({code, title, titleGenitive, titlePrepositional}) => {
    if (!code || !title || !titleGenitive || !titlePrepositional) {
        return null;
    }

    if (titlePrepositional === 'None None') {
        titlePrepositional = title;
    }

    return {code, title, titleGenitive, titlePrepositional};
};

const setCountries = (state, payload) => ({
    ...state,
    countries: Array.isArray(payload)
        ? payload.map(getDataOfCountry).filter(Boolean)
        : defaultState.countries,
});

const getSecondaryCityData = ({slug, title, stations, titleGenitive}) => {
    if (!title || !titleGenitive || !slug || !stations.length) {
        return null;
    }

    return {
        slug,
        title,
        titleGenitive,
        stations: setStations(stations),
    };
};

const setSecondaryCity = (state, payload) => ({
    ...state,
    secondaryCity: getSecondaryCityData(payload) || defaultState.secondaryCity,
});

const setPopularDirections = (state, payload) => ({
    ...state,
    popularDirections: Array.isArray(payload)
        ? payload.map(getDataOfPopularDirection).filter(Boolean)
        : defaultState.popularDirections,
});

const setDataForFetchingPage = (state, {transportType}) => {
    state = defaultState;
    state = setTransportType(state, transportType);

    return state;
};

const getDataOfCity = ({slug, title, stationId, pageType, mainSubtype}) => {
    if (!title || (!slug && !stationId)) {
        return null;
    }

    return {
        title,
        slug,
        stationId,
        pageType,
        mainSubtype,
    };
};

const setCities = (state, payload) => ({
    ...state,
    cities: Array.isArray(payload)
        ? payload.map(getDataOfCity).filter(Boolean)
        : defaultState.cities,
});

const setDataFromAPI = (
    state,
    {
        cities,
        mainCity,
        articles,
        countries,
        secondaryCity = {},
        popularDirections,
    },
) => {
    state = setCities(state, cities);
    state = setMainCity(state, mainCity);
    state = setCountries(state, countries);
    state = setSecondaryCity(state, secondaryCity);
    state = setArticles(state, articles);
    state = setPopularDirections(state, popularDirections);

    return state;
};

const reducers = {
    [SET_DATA_FOR_FETCHING_PAGE]: setDataForFetchingPage,
    [SET_DATA_FROM_API]: setDataFromAPI,
};

export default makeReducer(defaultState, reducers);
