import {
    SET_DATA_FROM_API,
    SET_DATA_FOR_FETCHING_PAGE,
} from '../actions/transportCity';

import {makeReducer} from '../lib/reduxUtils';

import {
    getDataOfStation,
    getDataOfArticle,
    getDataOfPopularDirection,
} from './transportPages';

const defaultState = {
    transportType: '',
    settlement: {
        key: '',
        id: 0,
        slug: '',
        title: '',
        titleGenitive: '',
    },
    stations: [],
    popularDirections: [],
    articles: [],
};

const setTransportType = (state, payload) => ({
    ...state,
    transportType: payload || defaultState.transportType,
});

const getSettlementData = ({key, id, slug, title, title_genitive}) => {
    if (!key || !id || !slug || !title) {
        return null;
    }

    return {
        key,
        id,
        slug,
        title,
        titleGenitive: title_genitive || defaultState.settlement.titleGenitive,
    };
};

const setSettlement = (state, payload) => {
    const settlement = getSettlementData(payload);

    return {
        ...state,
        settlement: settlement || defaultState.settlement,
    };
};

const setStations = (state, payload) => ({
    ...state,
    stations: Array.isArray(payload)
        ? payload.map(getDataOfStation).filter(Boolean)
        : defaultState.stations,
});

const setPopularDirections = (state, payload) => ({
    ...state,
    popularDirections: Array.isArray(payload)
        ? payload.map(getDataOfPopularDirection).filter(Boolean)
        : defaultState.popularDirections,
});

const setArticles = (state, payload) => ({
    ...state,
    articles: Array.isArray(payload)
        ? payload.map(getDataOfArticle).filter(Boolean)
        : defaultState.articles,
});

const setDataForFetchingPage = (state, {transportType}) => {
    state = defaultState;
    state = setTransportType(state, transportType);

    return state;
};

const setDataFromAPI = (
    state,
    {settlement, stations, popularDirections, articles},
) => {
    state = setSettlement(state, settlement);
    state = setStations(state, stations);
    state = setPopularDirections(state, popularDirections);
    state = setArticles(state, articles);

    return state;
};

const reducers = {
    [SET_DATA_FOR_FETCHING_PAGE]: setDataForFetchingPage,
    [SET_DATA_FROM_API]: setDataFromAPI,
};

export default makeReducer(defaultState, reducers);
