export const getDataOfStation = ({
    title,
    id,
    pageType,
    mainSubtype,
    page_type,
    main_subtype,
}) => {
    if (!title || !id) {
        return null;
    }

    return {
        title,
        id,
        pageType: pageType || page_type,
        mainSubtype: mainSubtype || main_subtype,
    };
};

export const getDataOfArticle = ({title, description, slug}) => {
    if (!title || !description || !slug) {
        return null;
    }

    return {
        slug,
        title,
        description,
    };
};

const getDataOfStationForPopularDirections = ({title, slug, key}) => {
    if (!title || !slug || !key) {
        return null;
    }

    return {
        title,
        slug,
        key,
    };
};

export const getDataOfPopularDirection = ({from, to}) => {
    from = getDataOfStationForPopularDirections(from);
    to = getDataOfStationForPopularDirections(to);

    if (!from || !to) {
        return null;
    }

    return {from, to};
};
