import {handleActions} from 'redux-actions';

import {
    setYandexUid,
    setSecretKey,
    setBlackboxData,
    setNetworkTraits,
    setUnreadMailCount,
    setOperationalSystem,
    setBrowser,
    setIsBot,
    setClientId,
} from '../actions/user';

const DEFAULT_STATE = {
    loggedIn: false,
    os: {},
    browser: {},
    avatar: null,
    networkTraits: {},
    yandexuid: null,
    secretkey: null,
    displayName: null,
    unreadMailCount: 0,
    isBot: false,
    clientId: undefined,
};

const user = handleActions(
    {
        [setYandexUid]: (state, {payload}) => ({
            ...state,
            yandexuid: payload,
        }),

        [setSecretKey]: (state, {payload}) => ({
            ...state,
            secretkey: payload,
        }),

        [setBlackboxData]: (state, {payload}) => ({
            ...state,
            ...payload,
        }),

        [setNetworkTraits]: (state, {payload}) => ({
            ...state,
            networkTraits: payload,
        }),

        [setUnreadMailCount]: (state, {payload}) => ({
            ...state,
            unreadMailCount: payload,
        }),

        [setOperationalSystem]: (state, {payload}) => ({
            ...state,
            os: payload,
        }),

        [setBrowser]: (state, {payload}) => ({
            ...state,
            browser: payload,
        }),

        [setIsBot]: (state, {payload}) => ({
            ...state,
            isBot: Boolean(payload),
        }),

        [setClientId]: (state, {payload}) => ({
            ...state,
            clientId: payload,
        }),
    },
    DEFAULT_STATE,
);

export default user;
