import {
    SEARCH_TRANSPORT_TYPES,
    TRANSPORT_CITY_TRANSPORT_TYPES,
    TRANSPORT_TYPES_IN_REQUEST_FOR_SEARCH_WITH_SLUGS,
} from './lib/transportType';
import {LASTOCHKA} from './routes/searchWithSlugs';

import StationSubtype from './interfaces/state/station/StationSubtype';
import StationType from './interfaces/state/station/StationType';

import search from './routes/search';
import redirectTransportSearch from './routes/redirectTransportSearch';
// eslint-disable-next-line no-duplicate-imports
import searchWithSlugs from './routes/searchWithSlugs';
import city from './routes/city';
import redirectToTrainService from './routes/redirectToTrainService';
import redirectToTrainsOrder from './routes/redirectToTrainsOrder';
import redirectToTravelService from './routes/redirectToTravelService';
import thread from './routes/thread';
import station from './routes/station';
import transportCity from './routes/transportCity';
import transport from './routes/transport';
import page404 from './routes/page404';
import info from './routes/info';
import index from './routes';

import preventRefreshPage from './middleware/preventRefreshPage';
import hit from './middleware/hit';
import now from './middleware/now';
import fullUrl from './middleware/fullUrl';
import suburbanWidget from './middleware/suburbanWidget';

const searchTransportTypesRegexp = SEARCH_TRANSPORT_TYPES.join('|');
const transportTypesForSearchWithSlugsRegexp =
    TRANSPORT_TYPES_IN_REQUEST_FOR_SEARCH_WITH_SLUGS.join('|');
const transportCityTransportTypesRegexp =
    TRANSPORT_CITY_TRANSPORT_TYPES.join('|');
const stationPageTransportTypesRegexp = [
    ...Object.values(StationSubtype),
    ...Object.values(StationType),
].join('|');

export default function router(app, {isServer}) {
    app.get('*', preventRefreshPage);
    app.get('*', now);
    app.get('*', fullUrl);
    app.get('*', hit);

    app.get('/nearest/suburban', suburbanWidget);

    app.get('/search/next', search);
    app.get(
        `/search/:transportType(${searchTransportTypesRegexp})/next`,
        search,
    );
    app.get(
        `/search/:transportType(${searchTransportTypesRegexp})?`,
        redirectTransportSearch,
    );
    app.get(`/search/:transportType(${searchTransportTypesRegexp})?`, search);

    app.get(`/:name(${LASTOCHKA})/:fromSlug--:toSlug`, searchWithSlugs);
    app.get(
        `/:transportType(${transportTypesForSearchWithSlugsRegexp})/:fromSlug--:toSlug/:when(today)?`,
        searchWithSlugs,
    );
    app.get(
        `/:transportType(${transportCityTransportTypesRegexp})/:citySlug`,
        transportCity,
    );
    app.get(`/:transportType(${transportCityTransportTypesRegexp})`, transport);

    app.get(
        '/order/:orderStep(passengers|confirm|payment)?',
        redirectToTrainService('/'),
    );
    app.get('/orders/search/', redirectToTravelService('/my'));
    app.get(
        '/orders/:page(refund|registration)?/:orderId?',
        redirectToTrainsOrder(),
    );

    app.get('/trains', redirectToTrainService('/'));
    app.get('/trains/sapsan', redirectToTrainService('/'));

    app.get('/thread/:threadId', thread);

    app.get(
        `/station/:id/:subtype(${stationPageTransportTypesRegexp})?`,
        station,
    );

    // Перед раскаткой новой страницы /info на все статьи убери костыль для редиректа на тач в server/middleware/alt-redirects.js
    app.get('/info/:slugOrId(covid-19*)', info);

    app.get('/city/:id', city);
    app.get('/', index);

    // обработка 404
    if (!isServer) {
        app.get('*', ({req, next}) => {
            try {
                // помечаем запрос, как не обработанный, чтобы модуль page не выполнял
                // вызов history.pushState и корректно работала кнопка "назад" в браузере
                req.handled = false;
                window.location.href = req.path;
            } catch (err) {
                next(err);
            }
        });
    }

    if (isServer) {
        // отдаем 404 только с сервера, т.к. только в этом случае будет корректно отрабатывать
        // логика nginx с проксированием к проектам touch и morda
        app.get('*', page404);
    }
}
