import {HOME_PAGE_NAME} from './index';
import {ERROR_TYPES} from '../lib/errors/errorTypes';

import scrollWindow from '../../client/lib/scrollWindow';

import {startFetchingPage, finishFetchingPage} from '../../common/actions/page';
import {setCurrentSettlement} from '../../common/actions/setCurrentSettlement';
import requestHomePage from '../actions/requestHomePage';

export default function city({req, res, next, api, store}) {
    const {dispatch} = store;
    const {language, nationalVersion, page} = store.getState();
    const {id} = req.params;

    if (page.current !== HOME_PAGE_NAME) {
        scrollWindow(0);
    }

    api.exec('settlement', {language, id}, req)
        .then(settlement => {
            if (settlement) {
                dispatch(startFetchingPage(HOME_PAGE_NAME));
                dispatch(setCurrentSettlement(settlement));

                return dispatch(
                    requestHomePage({
                        req,
                        language,
                        settlement,
                        nationalVersion,
                        isCity: true,
                    }),
                );
            }

            const error = new Error(`Settlement with id "${id}" not found`);

            error.type = ERROR_TYPES.SETTLEMENT_NOT_FOUND;

            throw error;
        })
        .then(() => {
            dispatch(finishFetchingPage(HOME_PAGE_NAME));

            return res.render();
        })
        .catch(error => {
            if (error.type === ERROR_TYPES.SETTLEMENT_NOT_FOUND) {
                // отдаем 404
                return next();
            }

            return next(error);
        });
}
