import scrollWindow from '../../client/lib/scrollWindow';

import {startFetchingPage, finishFetchingPage} from '../../common/actions/page';
import {setCurrentSettlement} from '../../common/actions/setCurrentSettlement';
import requestHomePage from '../actions/requestHomePage';

export const HOME_PAGE_NAME = 'home';

export default function index({req, res, next, store}) {
    const {dispatch, getState} = store;
    const {language, clientSettlement, nationalVersion, page} = getState();

    if (page.current !== HOME_PAGE_NAME) {
        scrollWindow(0);
    }

    dispatch(startFetchingPage(HOME_PAGE_NAME));
    dispatch(setCurrentSettlement(clientSettlement));

    return dispatch(
        requestHomePage({
            req,
            language,
            settlement: clientSettlement,
            nationalVersion,
            isCity: false,
        }),
    )
        .then(() => {
            dispatch(finishFetchingPage(HOME_PAGE_NAME));

            return res.render();
        })
        .catch(next);
}
