import {batch} from 'react-redux';

import IRouteMiddlewareParams from '../interfaces/router/IRouteMiddlewareParams';
import IInfoReqParams from '../interfaces/state/info/IInfoReqParams';

import Error404 from '../lib/errors/Error404';
import scrollWindow from '../../client/lib/scrollWindow';

import {startFetchingPage, finishFetchingPage} from '../actions/page';
import {setDataForFetchingPage, setDataFromAPI} from '../actions/info';

export const INFO_PAGE_NAME = 'info';

export default async function info({
    req,
    res,
    store,
    api,
    next,
    logger,
}: IRouteMiddlewareParams): Promise<void> {
    scrollWindow(0);

    try {
        const {getState, dispatch} = store;

        const {language} = getState();

        const {slugOrId} = req.params as IInfoReqParams;

        batch(() => {
            dispatch(startFetchingPage(INFO_PAGE_NAME));
            dispatch(setDataForFetchingPage());
        });

        const infoData = await api.execStaticPage({slugOrId, language}, req);

        batch(() => {
            dispatch(setDataFromAPI(infoData));
            dispatch(finishFetchingPage(INFO_PAGE_NAME));
        });

        return res.render();
    } catch (error) {
        logger.error('common/routes/info.ts', error, {level: 'error'});

        if (error.statusCode === 404) {
            // eslint-disable-next-line no-ex-assign
            error = new Error404();
        }

        // В случае ошибки поопробуем отобразить на старом стеке
        return next();
    }
}
