import {batch} from 'react-redux';

import {getWhenForToday} from '../lib/search/contextUtils';
import scrollWindow from '../../client/lib/scrollWindow';

import {finishFetchingPage} from '../../common/actions/page';
import {
    setFromPointFromUser,
    setToPointFromUser,
    setWhen,
} from '../actions/searchForm';

export const PAGE_404 = '404';

export default function page404({res, next, store}) {
    scrollWindow(0);

    const {dispatch} = store;
    const {clientSettlement, language} = store.getState();

    const {title} = clientSettlement;

    batch(() => {
        dispatch(setFromPointFromUser(title));
        dispatch(setToPointFromUser(''));
        dispatch(setWhen(getWhenForToday(language)));
        dispatch(finishFetchingPage(PAGE_404));
    });

    res.status(404);

    return res.render().catch(next);
}
