import {IMiddleware} from '../interfaces/IMiddleware';

import getTrainDomain from '../lib/url/getTrainDomain';

export default function redirectToTrainService(path): IMiddleware {
    return ({store, res}) => {
        const {page, environment} = store.getState();
        const {production: isProduction} = environment;
        const {location} = page;
        const urlPath = path || location.pathname;

        return res.redirect(301, `${getTrainDomain(isProduction)}${urlPath}`);
    };
}
