import {IMiddleware} from '../interfaces/IMiddleware';

import getTrainDomain from '../lib/url/getTrainDomain';
import getTravelDomain from '../lib/url/getTravelDomain';

export default function redirectToTrainsOrder(): IMiddleware {
    return ({store, res, req}) => {
        const {orderId} = req.params;
        const {environment} = store.getState();
        const {production: isProduction} = environment;

        if (orderId) {
            return res.redirect(
                301,
                `${getTravelDomain({isProduction})}/my/order/${orderId}`,
            );
        }

        return res.redirect(301, getTrainDomain(isProduction));
    };
}
