import {IMiddleware} from '../interfaces/IMiddleware';

import getTravelDomain from '../lib/url/getTravelDomain';

export default function redirectToTravelService(path): IMiddleware {
    return ({store, res}) => {
        const {page, environment} = store.getState();
        const {location} = page;
        const {production: isProduction} = environment;
        const urlPath = path || location.pathname;

        return res.redirect(
            301,
            `${getTravelDomain({isProduction})}${urlPath}`,
        );
    };
}
