import {SPECIAL_VALUES} from '../lib/date/values';

import DateSpecialValue from '../interfaces/date/DateSpecialValue';

import searchErrorHandler from './utils/searchErrorHandler';
import getAllDaySearchUrlToRedirect from '../lib/url/searchRedirect';

import {setFormDataFromRequest, validate} from '../actions/searchForm';

export default function redirectTransportSearch({
    req,
    res,
    store,
    next,
    logger,
    ApiError,
}) {
    const {dispatch, getState} = store;
    const {language, tld} = getState();

    if (req.query.when !== SPECIAL_VALUES[language][DateSpecialValue.allDays]) {
        return next();
    }

    const {query, params, searchNext} = req;

    dispatch(setFormDataFromRequest(query, params, Boolean(searchNext)));

    return Promise.resolve()
        .then(() => dispatch(validate(req)))
        .then(() => {
            const {searchForm: newSearchForm, page} = getState();

            const newUrl = getAllDaySearchUrlToRedirect({
                searchForm: newSearchForm,
                page,
                tld,
                language,
            });

            res.redirect(301, newUrl);
        })
        .catch(err => searchErrorHandler(err, {store, res, logger, ApiError}))
        .catch(next);
}
