import IState from '../../interfaces/state/IState';

import {params} from '../../lib/yaMetrika';

// Добавляет параметры визита для страницы поиска в метрику
export default function searchAddParamsOfVisit(state: IState): void {
    const {
        search: {
            context: {
                from: {slug: fromSlug},
                to: {slug: toSlug},
                when: {text: when},
                transportType,
            },
        },
    } = state;

    params({
        fromSlug,
        toSlug,
        when,
        transportType,
    });
}
