import {SEARCH} from '../search';

import {ERROR_TYPES, ParseError} from '../../lib/errors/errorTypes';

import {noResults} from '../../actions/search/search';
import {finishFetchingPage} from '../../actions/page';
import {InterruptError} from '../../lib/errors/executionErrors';
import EnvironmentType from '../../interfaces/EnvironmentType';

export default function searchErrorHandler(err, params) {
    const {store, res, logger, ApiError} = params;
    const {dispatch, getState} = store;

    switch (true) {
        // TODO: Назвать ошибку более понятно, например SearchContextParseError
        case err instanceof ParseError:
            if (
                err.type === ERROR_TYPES.SEARCH_NEXT_DEFAULT_DIRECTION_NOT_FOUND
            ) {
                return res.redirect('/');
            }

            if (err.type === ERROR_TYPES.NO_ROUTES) {
                dispatch(noResults());
                dispatch(finishFetchingPage(SEARCH));
                res.status(404);

                return res.render();
            }

            dispatch(finishFetchingPage(err.type));
            res.status(404);

            return res.render();
        // TODO: кидать ApiError из ручек
        case err instanceof ApiError:
            logger.error('search/ApiError', err);
            dispatch(finishFetchingPage(ERROR_TYPES.COMMON));

            return res.render();
        // Для клиента актуален только последний запрос
        case err instanceof InterruptError &&
            getState().environment.type === EnvironmentType.client:
            break;

        default:
            throw err;
    }
}
