/**
 * Почему здесь есть moment, Helmet и Loadable?
 *
 * Потому что в бандл для node попадают копии(!) пакетов из node_modules.
 * Внутри них есть код, который шариться между сервером и бандлом для ноды.
 * Поэтому если импортировать эти пакеты из node_modules на сервере, то там будет другая копия, что приведет к некорректной работе.
 * В moment задается локаль. В Helmet содержится мета-информация. В Loadable попадают модули через import().
 *
 * Как можно решить?
 *
 * Либо смириться, либо в конфиге вебпака подключить "webpack-node-externals".
 *
 *
 * Почему здесь есть ReactDOMServer?
 *
 * Потому что он минифицируется и работает быстрее.
 */

import ReactDOMServer from 'react-dom/server';
import {Provider} from 'react-redux';

import StaticContext from '../common/components/StaicContext/StaticContext';

import {Root, moment, Helmet, Loadable} from './components/Root/Root';

export {
    Root,
    moment,
    Helmet,
    Loadable,
    ReactDOMServer,
    Provider,
    StaticContext,
};
