import {createStore, combineReducers, applyMiddleware, compose} from 'redux';

import createThunkMiddleware from './storeMiddleware/createThunkMiddleware';

import tld from './reducers/tld';
import language from './reducers/language';
import nationalVersion from './reducers/nationalVersion';
import clientSettlement from './reducers/clientSettlement';
import currentSettlement from './reducers/currentSettlement';
import searchForm from './reducers/searchForm';
import searchFormHints from './reducers/searchFormHints';
import {search} from './reducers/search';
import page from './reducers/page';
import altLinks from './reducers/altLinks';
import suggests from './reducers/suggests';
import currencies from './reducers/currencies';
import environment from './reducers/environment';
import linkToTracer from './reducers/linkToTracer';
import nonce from './reducers/nonce';
import generatedInputName from './reducers/generatedInputName';
import user from './reducers/user';
import searchCalendar from './reducers/searchCalendar';
import flags from './reducers/flags';
import tooltip from './reducers/tooltip';
import platform from './reducers/platform';
import isTouch from './reducers/isTouch';
import directions from './reducers/directions';
import bugReporter from './reducers/bugReporter';
import stationsGroup from './reducers/stationsGroup';
import popularDirections from './reducers/popularDirections';
import teasers from './reducers/teasers';
import seoQueryParams from './reducers/seoQueryParams';
import thread from './reducers/thread';
import transportCity from './reducers/transportCity';
import transport from './reducers/transport';
import station from './reducers/station';
import home from './reducers/home';
import info from './reducers/info';

function typeActionToString(type) {
    return typeof type === 'symbol'
        ? type.toString().replace(/^Symbol\(|\)$/g, '')
        : type;
}

export default function injectToCreateStore(thunkInjections) {
    const reducer = combineReducers({
        tld,
        language,
        nationalVersion,
        clientSettlement,
        currentSettlement,
        searchForm,
        searchFormHints,
        search,
        page,
        altLinks,
        directions,
        popularDirections,
        stationsGroup,
        suggests,
        currencies,
        user,
        environment,
        linkToTracer,
        nonce,
        generatedInputName,
        searchCalendar,
        tooltip,
        flags,
        platform,
        isTouch,
        bugReporter,
        teasers,
        seoQueryParams,
        thread,
        transportCity,
        transport,
        station,
        home,
        info,
    });

    const composeEnhancers =
        typeof window === 'object' &&
        window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__
            ? window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__({
                  // позволяет отображать в redux dev tools типы у экшенов
                  actionSanitizer: action => {
                      action.type = typeActionToString(action.type);

                      return action;
                  },
              })
            : compose;
    const createStoreWithMiddleware = composeEnhancers(
        applyMiddleware(createThunkMiddleware(thunkInjections)),
    )(createStore);

    return initialState => createStoreWithMiddleware(reducer, initialState);
}
