#!/usr/bin/env python3
# coding: utf-8

import json
import os

from datetime import datetime


if __name__ == '__main__':
    stage_id = os.environ.get('DEPLOY_STAGE_ID')
    env_vars = stage_id.split('-')
    project = env_vars[0]
    environment = env_vars[-1]
    application = '-'.join(env_vars[1:-1])

    env_dict = {
        'TRAVEL_DEPLOY_PROJECT': project,
        'TRAVEL_DEPLOY_APPLICATION': application,
        'TRAVEL_DEPLOY_ENVIRONMENT': environment,
        'TRAVEL_DEPLOY_UNIT': os.environ.get('DEPLOY_UNIT_ID'),
        'TRAVEL_DEPLOY_HOST': os.environ.get('DEPLOY_POD_PERSISTENT_FQDN'),
        'TRAVEL_DEPLOY_HTTP_PORT': os.environ.get('TRAVEL_DEPLOY_HTTP_PORT', 80)
    }

    env_text = '\n'.join('{}={}'.format(k, v) for k, v in env_dict.items())

    with open('/bin/.env', 'w') as f:
        f.writelines(env_text + '\n')
