#!/bin/bash

set -ev

cd /app

chmod -R 755 ./*

mkdir pre_start
mkdir -p /var/log/app/yt/
cp -r docker/pre_start/. pre_start
cp -r docker/bin/. /opt/bin
cp -r docker/root/. /root

# предполагается, что геобаза как ресурс была подготовлена заранее
mkdir -p /var/cache/geobase
cp docker/resources/geodata6.bin /var/cache/geobase/

mv /etc/apt/sources.list.d/nodesource.list /etc/apt/sources.list.d/nodesource.list.disabled
apt-get update
apt-get install -y ca-certificates libgnutls30
mv /etc/apt/sources.list.d/nodesource.list.disabled /etc/apt/sources.list.d/nodesource.list

# logrotate
apt-get install -y -qq  yandex-logrotate=3.7.8.20600~yandex \
                        yandex-lockf
rm -rf /etc/logrotate.d
cp -r docker/logrotate/. /etc/
install -d -o app -g app /var/log/logrotate

#cron
apt-get install -y -qq cron=3.0pl1-128ubuntu2
cp docker/cron/yandex-logrotate /etc/cron.d/
chmod -R 600 /etc/cron.d/.
# Cron bug https://bugs.debian.org/cgi-bin/bugreport.cgi?bug=726661
sed -i '/session    required     pam_loginuid.so/c\#session    required     pam_loginuid.so' /etc/pam.d/cron
if [ -e /etc/cron.daily/logrotate ]; then rm /etc/cron.daily/logrotate; fi;

# push-client
apt-get install -y -qq yandex-push-client=6.73.1
cp -r docker/statbox-push-client/. /etc/statbox-push-client/

# jaeger-agent
curl https://proxy.sandbox.yandex-team.ru/1317359659 > /bin/jaeger-agent && chmod +x /bin/jaeger-agent
mkdir -p /etc/jaeger-agent/ && cp -r docker/jaeger-agent/. /etc/jaeger-agent/

# nginx
cp -r docker/nginx/. /etc/nginx/

# supervisor
cp -r docker/supervisor/. /etc/supervisor/
mkdir -p /var/log/supervisor/apps/

# other
apt-get install -y -qq  git \
                        nano \
                        gettext=0.19.7-2ubuntu3.1 \
                        lsof=4.89+dfsg-0.1

# bindings
apt-get install -y -qq  libgeobase6=6.0-37 \
                        libgeobase6-abi=6.0-37 \
                        libgeobase6-nodejs=6.0-37 \
                        yandex-lang-detect-data \
                        yandex-lang-detect-nodejs \
                        libyandex-lang-detect \
                        libuatraits \
                        uatraits-data

# build app
npm ci
npm run build
npm run babel-all

npm run upload:sourcemaps

# удаляем все ненужное для экономии размера образа
rm -rf /root/.npm
rm -f id_rsa

if [ $RASP_CONTAINER_RUN_LOCALLY = "1" ]
then
cp /app/docker/nginx/includes/listen-https /etc/nginx/listen
fi
