/**
 * Это мини прокси-сервер для проксирования запросов из parallels в docker.
 * Способ использования описан в README.md проекта
 * @type {module:http}
 */
const http = require('http');

const portFrom = 80;
const portTo = 3000;

http.createServer(onRequest).listen(portFrom);

// eslint-disable-next-line no-console
console.log(`proxy listen on ${portFrom}`);

function onRequest(client_req, client_res) {
    // eslint-disable-next-line no-console
    console.log(`serve: ${client_req.url}`);

    const options = {
        hostname: 'localhost',
        port: portTo,
        path: client_req.url,
        method: client_req.method,
        headers: client_req.headers,
    };

    const proxy = http.request(options, res => {
        client_res.writeHead(res.statusCode, res.headers);
        res.pipe(client_res, {
            end: true,
        });
    });

    client_req.pipe(proxy, {
        end: true,
    });
}
