# Общие правила по стилю кода JS

## Объявление переменных и деструктуризация объектов

-   Для объявления переменных использовать разрешено только **_let_** и **_const_**

-   Каждое объявление переменной должно быть на отдельной строчке

Правильно:

```
let foo;
let bar;
let fooBar;
const a;
const b;
const c;
```

Неправильно:

```
let foo, bar, fooBar;
const a, b, c;
```

-   Деструктуризация объектов при объявлении переменной должна быть следующего формата (это все Лев @lorekhov):

Правильно:

```
const { density,
        startTime,
        endTime } = thread;
```

Неправильно:

```
const {
     density,
     startTime,
     endTime
} = thread;
```

-   Создание переменной-объекта:

Правильно:

```
const obj: IObj = {
    pam,
    param: pams
};
```

Неправильно:

```
const obj: IObj = { pam,
                    param: pams };
```

## Импорты

Импорты всегда пишем в начале файла в следующем порядке:

1. `common/components/base` - данный файл считается легаси и более не содержит в себе ничего необходимого для работы. Не нужно его использовть в новых файлах.
2. Внешние модули
3. Константы
4. Перечисления, типы и интерфейсы
5. Модули из `common/lib`
6. Экшены из `common/actions`
7. Компоненты и React-контексты
8. Кейсеты `common/i18n`

Если импортов много (≥4), стоит разделить эти группы пустыми строками.

```
// Базовый импорт
import { React, PureComponent, B } from '../base';

// Внешние модули
import get from 'lodash/get';
import moment from 'moment';
import momentTimezone, { Moment } from '../../reexports/moment-timezone'; // moment-timezone переэкспортируем, так как мы импользуем урезанную версию данных о таймзонах

// Константы
import { TRAIN_TYPE } from '../../lib/transportTypes';

// Перечисления, типы и интерфейсы
import { Lang } from '../../lib/langCodes';

// Библиотеки и экшены
import { composeSearchAction } from '../../lib/searchQuery';
import { setFrom, setTo, setWhen, swap } from '../../actions/searchForm';

// Компоненты
import Icon from '../Icon/Icon';
import Button from '../Button/Button';
import DatePicker from '../DatePicker/DatePicker';

// Кейсеты
import keyset from '../../i18n/search';
```

## Экспорты

Используем синтаксис es-модудей (import, export) как в клиентской части приложения, так и в серверной, за исключением файлов-точек входа, где просиходит подключение файлов, отвечающих за транспиляцию кода "на лету" (transpilerOnFly.js) в режиме локальной разработки.

Нужно стараться придерживаться логики "Один файл - один дефолтный экспорт" (`default export`).
Данного правила нужно придерживаться при создании нового функционала и при рефакторинге существующего.
Возможны случаи, когда применение дополнительных экспортов оправдано, но придежживайтесь здравого смысла и не злоупотребляйте ими.

Причины появления данного правила в проекте:

1. Проще производить рефакторинг. Как логический (изменение логики работы), так и синтаксический (перевод js-кода на ts).
2. Меньше конфликтов при мерджах.
3. Проще писать тесты.
4. Проще читать код.
