# Правила оформления React-компонентов

Внимание! Этот документ является скорее руководством к действию, чем описанием текущей ситуации, то есть:

-   Новые компоненты нужно разрабатывать в соответствии с этим документом
-   Старые компоненты приводить в соответствие по возможности

## Файловая структура

-   В проекте используется [БЭМ](https://ru.bem.info/methodology/quick-start/) как идеология для структуризации компонентов и работы с css.
-   Все компоненты живут в `/common/components/`.
-   Компоненты должны иметь плоскую структуру - то есть каждый компонент лежит в своей папке. Так обеспечивается уникальность имен классов. Иначе возможны пересечения имен классов со всеми сложно прогнозируемыми последствиями.
-   Папка с компонентом имеет то же название, что и класс компонента.
-   Если компонент с таким названием уже существует, то возможно вы собираетесь написать еще одну его реализацию - в таком случае лучше модифицировать имеющийся компонент. Если компонент специфичен для определенной страницы, то лучше добавить ему префикс с названием страницы, например `ThreadPageSomeComponent`.
-   В папке компонента должен лежать как минимум сам компонент в файле `<nameComponent>.tsx` или `<nameComponent>.mobile.tsx` (для мобильной версии) и `<nameComponent>.desktop.tsx` (для десктопной версии).
-   Стили компонента лежат рядом в файле `<fileNameComponent>.styl` (где `fileNameComponent` - имя файла без расширения) - это нужно для подключения стилей в процессе сборки.

Также в `components` лежит папка `_styles` с общими стилями. Исключительно для быстрого доступа, компонентов там нет и не будет.

## Генерация CSS-классов

Генерируем CSS-классы с помощью [bem-cn-lite](https://github.com/mistakster/bem-cn-lite).
Базовый генератор для компонента объявляем сразу после импортов:

```
const b = B('MyComponent');
```

В названиях CSS-классов используем `camelCase`, всё остальное bem-cn сделает за вас.

В компонентах поддерживаем возможность передачи свойства `className`, добавляем его как последний аргумент для `bem-cn-lite`:

```
import B from 'bem-cn-lite';

const b = B('MyComponent');

interface IMyComponentProps {
    className?: string;
}

const MyComponent: React.FC<IMyComponentProps> = ({ className }) => {
    return (
        <div className={b(undefined, className)} />
    );
};
```

## Декларация компонентов

Декларируем компоненты как функциональные. `createClass` и классовые компоненты не используем. Компонент делаем экспортом по-умолчанию:

```
import React from 'react';
import B from 'bem-cn-lite';

const b = B('MyComponent');

interface IMyComponentProps {}

const MyComponent: React.FC<IMyComponentProps> = () => {
    return (
        <div className={b()}>
            My component content
        </div>
    );
};

export default React.memo(MyComponent);
```
