const coverageThreshold = require('./package').jest.coverageThreshold;
const args = process.argv && Array.from(process.argv);
// Тесты запускаются на определенных файлах.
// Необходимо, чтобы можно было смотреть результат покрытия тестами в нормальном виде (--coverage)
const isRunningWithCoverageFlag = args && args.indexOf('--coverage') !== -1;

const config = {
    verbose: true,
    moduleFileExtensions: ['tsx', 'ts', 'tsx', 'js', 'json'],
    testRegex: '__tests__/.*\\.test\\.[jt]s$',
    roots: ['common/', 'server/', 'tools/'],
    automock: false,
    clearMocks: true,
    testResultsProcessor: 'jest-teamcity-reporter',
    testEnvironment: 'node',
};

if (isRunningWithCoverageFlag) {
    config.collectCoverage = true;
    config.collectCoverageFrom = [
        'common/lib/**',
        '!common/lib/polling/**',
        '!**/node_modules/**',
    ];
    config.coverageReporters = ['html', 'json-summary', 'text-summary'];
    config.coverageThreshold = coverageThreshold; // т.к. coverage ratchet умеет писать только в package.json
}

module.exports = config;
