import environment from '@yandex-int/yandex-environment';
import {Api, ApiError, apiMiddleware as blaApiMiddleware} from 'bla';

import Environment from '../common/interfaces/Environment';

import logger from './logger';
import apiWrapper from '../common/lib/apiWrapper';

const isDev = environment === Environment.development;

// На контейнере возникает проблема после транспиляции: есть .ts файл, с которым нода не знает что делать
// Поэтому вне разработческого окружения смотрим только на .js ручки
const apiExtension = isDev ? '[jt]s' : 'js';
const api = new Api(`${__dirname}/api/*.${apiExtension}`);

export default apiWrapper(api);

export const apiPath = '/api/:method?';

const apiMiddleware = blaApiMiddleware(api, {enableDocPage: false});

const pathToFile = 'server/api';

export function setupApi(app) {
    app.use(apiPath, (req, res, next) => {
        const startTime = Date.now();

        return apiMiddleware(req, res, next)
            .then(() => {
                if (!isDev) {
                    const time = (Date.now() - startTime) / 1000;

                    logger.info(
                        pathToFile,
                        `api path: ${req.params.method} : _rid: ${req.requestId}, time: ${time} s`,
                    );
                }
            })
            .catch(next);
    });
    // При обращении к несуществующему методу api
    app.use(apiPath, (req, res) => res.json({}));
}

export {ApiError};
