import yaConfig from '@yandex-int/yandex-config';

import {createApiMethod} from '../helpers/api';

const {api: apiConfig} = yaConfig();

module.exports = createApiMethod({
    name: 'activeTrainPartners',
    params: {
        language: {
            type: 'String',
            required: true,
        },
    },
    requestConfigOptions: {
        ...apiConfig.purchaseOptions,
        timeout: 500,
    },
    buildPath: ({language}) => `/${language}/api/active-partners/`,
    buildOperationName: () => '/:language/api/active-partners/',
});
