import {apiTimedGot} from '../helpers/timedGot';
import {ApiMethod} from 'bla';
import yaConfig from '@yandex-int/yandex-config';

const {api: apiConfig} = yaConfig();

module.exports = new ApiMethod({
    name: 'altLinks',
    params: {
        url: {
            required: true,
        },
        from: {
            required: true,
        },
    },
    action: ({url, from}, req) =>
        apiTimedGot(
            {
                ...apiConfig.options,
                path: '/altlinks/',
                query: {
                    from,
                    url,
                },
                json: true,
            },
            req,
            {
                operationName: '/altlinks/',
            },
        ).then(({body}) => body),
});
