import {createApiMethod} from '../helpers/api';

module.exports = createApiMethod({
    name: 'articles',
    params: {
        language: {
            type: 'String',
            required: true,
        },
        country: {
            type: 'String',
            required: true,
        },
        transportType: {
            type: 'String',
            required: true,
        },
        settlementSlug: {
            type: 'String',
            defaultValue: '',
        },
        settlementId: {
            type: 'Number',
            required: false,
        },
        limit: {
            type: 'Number',
            defaultValue: 3,
        },
    },
    defaultResponse: {
        errors: {},
        result: {
            articles: [],
        },
    },

    buildPath: ({language}) => `/${language}/articles/`,
    buildOperationName: () => '/:language/articles/',

    buildQuery: ({
        country,
        settlementSlug,
        settlementId,
        limit,
        transportType,
    }) => ({
        country,
        settlement_slug: settlementSlug,
        settlement_id: settlementId,
        t_type: transportType,
        limit,
    }),
});
