import {ApiMethod, ApiError} from 'bla';
import yaConfig from '@yandex-int/yandex-config';

import IApi from '../../common/interfaces/api/IApi';
import IApiBlablacarCityLinkResponseBackend from '../../common/interfaces/api/IApiBlablacarCityLinkResponseBackend';
import IApiBlablacarCityLinkResponse from '../../common/interfaces/api/IApiBlablacarCityLinkResponse';

import logger from '../logger';
import {apiTimedGot} from '../helpers/timedGot';
import requestIsFailed from './utils/requestIsFailed';

const config = yaConfig();

const defaultAnswer: IApiBlablacarCityLinkResponse = {
    banned: false,
};

const action: IApi['execBlablacarCityLink'] = async (
    {nationalVersion, language, id},
    req,
) => {
    if (process.env.RIDESHARING_PARTNERS_DISABLED === 'true') {
        return defaultAnswer;
    }

    try {
        const response: {body: IApiBlablacarCityLinkResponseBackend} =
            await apiTimedGot(
                {
                    ...config.blablacar.requestOptions,
                    path: '/settlement/',
                    query: {nationalVersion, language, id},
                    json: true,
                },
                req,
                {
                    operationName: '/settlement/',
                },
            );

        const {body} = response;

        if (requestIsFailed(body)) {
            throw new ApiError(null, `Request failed: ${JSON.stringify(body)}`);
        }

        return {
            url: body.url || undefined,
            banned: body.banned ?? false,
        };
    } catch (err) {
        logger.error('server/api/blablacarCityLink', err, {
            level: 'error',
        });

        return defaultAnswer;
    }
};

module.exports = new ApiMethod({
    name: 'blablacarCityLink',
    params: {
        nationalVersion: {
            type: 'String',
            required: true,
        },
        language: {
            type: 'String',
            required: true,
        },
        id: {
            type: 'Number',
            required: true,
        },
    },
    action,
});
