import {ApiMethod} from 'bla';
import {logBusTariffs} from '../helpers/logs';

module.exports = new ApiMethod({
    name: 'busTariffsLogger',
    params: {
        context: {
            type: 'Object',
            required: true,
        },
        data: {
            type: 'Object',
            required: true,
        },
        nationalVersion: {
            type: 'String',
            required: true,
        },
    },
    action: ({context, data, nationalVersion}) => {
        const {from, to, when} = context;

        logBusTariffs({
            query: {
                pointFrom: from.key,
                pointTo: to.key,
                date: [when.date, when.nextDate],
                national_version: nationalVersion,
            },
            data,
        });
    },
});
