import {createApiMethod} from '../helpers/api';

module.exports = createApiMethod({
    name: 'disclaimers',
    params: {
        language: {
            required: true,
            type: 'String',
        },
        codes: {
            required: true,
            type: 'Object',
        },
    },
    buildPath: ({language}) => `/${language}/statictext/disclaimers/`,
    buildOperationName: () => '/:language/statictext/disclaimers/',
    buildQuery: ({codes}) => ({codes: codes.join(',')}),
});
