import {ApiMethod} from 'bla';
import yaConfig from '@yandex-int/yandex-config';

import {apiTimedGot} from '../helpers/timedGot';

const {api: apiConfig} = yaConfig();

module.exports = new ApiMethod({
    name: 'parseContext',
    params: {
        tld: {
            type: 'String',
            required: true,
        },
        language: {
            type: 'String',
            required: true,
        },
        transportType: {
            type: 'String',
            required: true,
        },
        fromSlug: {type: 'String'},
        fromKey: {type: 'String'},
        fromTitle: {type: 'String'},
        toSlug: {type: 'String'},
        toKey: {type: 'String'},
        toTitle: {type: 'String'},
    },
    action: (
        {
            tld,
            language,
            transportType,
            fromSlug,
            fromKey,
            fromTitle,
            toSlug,
            toKey,
            toTitle,
        },
        req,
    ) => {
        const query = {
            t_type: transportType,
            national_version: tld,
        };

        if (fromSlug) {
            query.from_slug = fromSlug;
        } else {
            query.from_key = fromKey;
            query.from_title = fromTitle;
        }

        if (toSlug) {
            query.to_slug = toSlug;
        } else {
            query.to_key = toKey;
            query.to_title = toTitle;
        }

        return apiTimedGot(
            {
                ...apiConfig.options,
                path: `/${language}/search/parse-context/`,
                query,
                json: true,
            },
            req,
            {
                operationName: '/:language/search/parse-context/',
            },
        ).then(({body}) => {
            return body;
        });
    },
});
