import {ApiMethod} from 'bla';
import yaConfig from '@yandex-int/yandex-config';

import {apiTimedGot} from '../helpers/timedGot';
import logger from '../logger';

const {api: apiConfig} = yaConfig();

module.exports = new ApiMethod({
    name: 'partnerSchedule',
    params: {
        pointFrom: {
            type: 'String',
            required: true,
        },
        pointTo: {
            type: 'String',
            required: true,
        },
        when: {
            type: 'String',
            required: true,
        },
        language: {
            type: 'String',
            required: true,
        },
    },
    action: ({pointFrom, pointTo, when, language}, req) => {
        const path = `/${language}/api/partner-schedule/`;

        const query = {
            pointFrom,
            pointTo,
            when,
        };

        return apiTimedGot(
            {
                ...apiConfig.purchaseOptions,
                path,
                query,
                json: true,
            },
            req,
            {
                operationName: '/:language/api/partner-schedule/',
            },
        )
            .then(({body}) => body)
            .catch(err => {
                logger.error('server/api/partnerSchedule', err);

                throw err;
            });
    },
});
