import yaConfig from '@yandex-int/yandex-config';
import {ApiMethod} from 'bla';

import {apiTimedGot} from '../helpers/timedGot';
import logger from '../logger';
import requestIsFailed from './utils/requestIsFailed';

const {api: apiConfig} = yaConfig();

const defaultAnswer = {
    isDefault: true,
    planeTariffs: {
        segments: [],
        querying: false,
    },
};

module.exports = new ApiMethod({
    name: 'planeTariffs',
    params: {
        qid: {
            type: 'String',
            required: true,
        },
        skip_partners: {
            type: 'Array',
            required: true,
        },
        language: {
            type: 'String',
            required: true,
        },
    },
    action: ({qid, skip_partners, language}, req) => {
        const query = {
            qid,
            skip_partners: JSON.stringify(skip_partners),
            yandexuid: req.cookies.yandexuid,
        };

        const path = `/${language}/tariffs/plane/poll/`;

        return apiTimedGot(
            {
                ...apiConfig.options,
                path,
                query,
                json: true,
            },
            req,
            {
                operationName: '/:language/tariffs/plane/poll/',
            },
        )
            .then(({body}) => {
                if (requestIsFailed(body)) {
                    throw new Error(
                        `Request is failed: ${JSON.stringify(body.errors)}`,
                    );
                }

                body.qid = qid;

                return {planeTariffs: body};
            })
            .catch(err => {
                logger.error('server/api/planeTariffs', err);

                return defaultAnswer;
            });
    },
});
