import {ApiMethod} from 'bla';
import yaConfig from '@yandex-int/yandex-config';

import {apiTimedGot} from '../helpers/timedGot';

const {api: apiConfig} = yaConfig();

module.exports = new ApiMethod({
    name: 'sampleSearchContext',
    params: {
        language: {
            required: true,
            type: 'String',
        },
        settlementId: {
            required: true,
        },
        nationalVersion: {},
    },
    action: ({settlementId, language, nationalVersion}, request) =>
        apiTimedGot(
            {
                ...apiConfig.options,
                path: `/${language}/settlement/${settlementId}/search-sample-points/`,
                query: {
                    _rid: request.requestId,
                    national_version: nationalVersion,
                },
                json: true,
            },
            request,
            {
                operationName:
                    ':language/settlement/:settlementId/search-sample-points/',
            },
        ).then(({body}) => body),
});
