import {ApiMethod} from 'bla';
import yaConfig from '@yandex-int/yandex-config';

import {apiTimedGot} from '../helpers/timedGot';
import logger from '../logger';
import requestIsFailed from './utils/requestIsFailed';
import {buildSegmentsFromTransfers} from '../../common/lib/segments/transfer/buildSegmentsFromTransfers';
import {logSearchTransfersResult} from '../helpers/logs';

const {api: apiConfig} = yaConfig();

const defaultAnswer = {
    transfers: [],
};

module.exports = new ApiMethod({
    name: 'searchTransfer',
    params: {
        context: {
            required: true,
        },
        /**
         * @todo Со временем небходимо сделать required: true.
         * Оставили для того, чтобы боты, которые обращаются к api не создавали фон ошибок.
         */
        trainProviderTesting: {
            type: 'Boolean',
            required: false,
            defaultValue: false,
        },
        /**
         * @todo Со временем небходимо убрать параметр flags.
         * Оставили для того, чтобы боты, которые обращаются к api не создавали фон ошибок.
         */
        flags: {
            type: 'Object',
            required: false,
            defaultValue: {},
        },
    },
    action: ({context}, req) => {
        const {transportType, from, to, when, language} = context;
        const query = {
            pointFrom: from.key,
            pointTo: to.key,
            timezones: [from.timezone, to.timezone],
        };

        if (transportType !== 'all') {
            query.transportType = transportType;
        }

        if (when.date) {
            query.when = when.date;
        }

        return apiTimedGot(
            {
                ...apiConfig.options,
                path: `/${language}/search/transfers/`,
                query,
                json: true,
            },
            req,
            {
                operationName: '/:language/search/transfers/',
            },
        )
            .then(({body}) => {
                if (requestIsFailed(body)) {
                    throw new Error(
                        `Request is failed: ${JSON.stringify(body.errors)}`,
                    );
                }

                const {transferVariants} = body;

                logSearchTransfersResult({
                    req,
                    query,
                    result: transferVariants,
                });

                const transfers = buildSegmentsFromTransfers({
                    transfers: transferVariants,
                    language,
                    transportType,
                });

                return {transfers};
            })
            .catch(err => {
                logger.error('server/api/searchTransfer', err);

                return defaultAnswer;
            });
    },
});
