import {createApiMethod} from '../helpers/api';

module.exports = createApiMethod({
    name: 'settlement',
    params: {
        id: {},
        language: {
            type: 'String',
            required: true,
        },
        nationalVersion: {
            type: 'String',
        },
        geoIds: {
            type: 'Object',
        },
        slug: {
            type: 'String',
        },
    },

    buildPath: ({language}) => `/${language}/settlement/`,
    buildOperationName: () => '/:language/settlement/',

    buildQuery: ({id, geoIds, nationalVersion, slug}) => ({
        id,
        root_domain: nationalVersion,
        national_version: nationalVersion,
        geo_ids: geoIds && geoIds.join(','),
        slug,
    }),

    // если ручка ничего не нашла, то она вернет null, а не 404
    onSuccess: ({geoIds}) =>
        geoIds && geoIds.length
            ? ({body}) => body && {...body, geo_id: geoIds[0]}
            : ({body}) => body,
});
