import yaConfig from '@yandex-int/yandex-config';
import {ApiMethod} from 'bla';

import {apiTimedGot} from '../helpers/timedGot';
import isDirtyBot from '../helpers/isDirtyBot';
import logger from '../logger';
import requestIsFailed from './utils/requestIsFailed';

const {api: apiConfig} = yaConfig();

const defaultAnswer = {
    isDefault: true,
    qids: [],
};

module.exports = new ApiMethod({
    name: 'startPlaneQuerying',
    params: {
        context: {
            type: 'Object',
            required: true,
        },
        nationalVersion: {
            type: 'String',
            required: true,
        },
        clientSettlementId: {
            type: 'Number',
            required: true,
        },
        poll: {
            type: 'Boolean',
            defaultValue: false,
        },
    },
    action: ({context, nationalVersion, clientSettlementId, poll}, req) => {
        if (!poll && isDirtyBot(req)) {
            return {
                ...defaultAnswer,
                isDirty: true,
            };
        }

        const {transportType, from, to, when, language} = context;

        const query = {
            pointFrom: from.key,
            pointTo: to.key,
            date: [when.date, when.nextDate],
            national_version: nationalVersion,
            clientSettlementId,
            _rid: req.requestId,
            yandexuid: req.cookies.yandexuid,
        };

        const path = `/${language}/tariffs/plane/`;

        if (transportType !== 'all') {
            query.transportType = transportType;
        }

        return apiTimedGot(
            {
                ...apiConfig.options,
                path,
                query,
                json: true,
            },
            req,
            {
                operationName: '/:language/tariffs/plane/',
            },
        )
            .then(({body}) => {
                if (requestIsFailed(body)) {
                    throw new Error(
                        `Request is failed: ${JSON.stringify(body.errors)}`,
                    );
                }

                return {planeQIds: body};
            })
            .catch(err => {
                logger.error('server/api/startPlaneQuerying', err);

                return defaultAnswer;
            });
    },
});
