import {ApiMethod, ApiError} from 'bla';
import yaConfig from '@yandex-int/yandex-config';

import IApi from '../../common/interfaces/api/IApi';
import IApiStaticPageResponseFromBackend from '../../common/interfaces/api/IApiStaticPageResponseFromBackend';

import {apiTimedGot} from '../helpers/timedGot';
import requestIsFailed from './utils/requestIsFailed';

const config = yaConfig();

const action: IApi['execStaticPage'] = async ({language, slugOrId}, req) => {
    const response: {body: IApiStaticPageResponseFromBackend} =
        await apiTimedGot(
            {
                ...config.api.options,
                path: `/${language}/staticpage/`,
                query: {slug: slugOrId},
                json: true,
            },
            req,
            {
                operationName: ':language/staticpage/',
            },
        );

    const {body} = response;

    if (requestIsFailed(body)) {
        throw new ApiError(null, `Request failed: ${JSON.stringify(body)}`);
    }

    const {
        result: {
            id,
            title,
            slug,
            content,
            meta_description: metaDescription,
            meta_title: metaTitle,
            children,
            parents,
        },
    } = body;

    return {
        id,
        slug: slug || undefined,
        title,
        content,
        metaDescription,
        metaTitle,
        children,
        parents,
    };
};

module.exports = new ApiMethod({
    name: 'staticPage',
    params: {
        language: {
            type: 'String',
            required: true,
        },
        slugOrId: {
            type: 'String',
            required: true,
        },
    },
    action,
});
