import {createApiMethod} from '../helpers/api';

module.exports = createApiMethod({
    name: 'stations',
    params: {
        settlementId: {
            // id или slug
            type: 'String',
            required: true,
        },
        language: {
            type: 'String',
            required: true,
        },
        transportType: {
            type: 'String',
        },
    },

    buildPath: ({language, settlementId}) => {
        return `/${language}/settlement/${settlementId}/stations/`;
    },
    buildOperationName: () => '/:language/settlement/:settlementId/stations/',
    buildQuery: ({transportType}) => ({t_type: transportType}),
});
