import {apiTimedGot} from '../helpers/timedGot';
import logger from '../logger';
import {ApiMethod} from 'bla';
import yaConfig from '@yandex-int/yandex-config';

import requestIsFailed from './utils/requestIsFailed';

const {api: apiConfig} = yaConfig();

module.exports = new ApiMethod({
    name: 'suburbanTariffs',
    params: {
        context: {
            type: 'Object',
            required: true,
        },
        nationalVersion: {
            type: 'String',
            required: true,
        },
        clientSettlementId: {
            type: 'Number',
            required: true,
        },
    },
    action: ({context, nationalVersion, clientSettlementId}, req) => {
        const {from, to, when, language} = context;

        const path = `/${language}/tariffs/suburban/`;

        const defaultAnswer = {
            suburbanTariffs: {
                tariffs: [],
                groups: [],
            },
        };

        const query = {
            pointFrom: from.key,
            pointTo: to.key,
            date: [when.date, when.nextDate],
            national_version: nationalVersion,
            clientSettlementId,
        };

        return apiTimedGot(
            {
                ...apiConfig.options,
                path,
                query,
                json: true,
            },
            req,
            {
                operationName: '/:language/tariffs/suburban/',
            },
        )
            .then(({body}) => {
                if (requestIsFailed(body)) {
                    throw new Error(
                        `Request is failed: ${JSON.stringify(body.errors)}`,
                    );
                }

                return {suburbanTariffs: body};
            })
            .catch(err => {
                logger.error('server/api/suburbanTariffs', err);

                return defaultAnswer;
            });
    },
});
