import {apiTimedGot} from '../helpers/timedGot';
import {ApiMethod} from 'bla';
import yaConfig from '@yandex-int/yandex-config';
import {SUBURBAN_TYPE} from '../../common/lib/transportType';

const {api: apiConfig} = yaConfig();

module.exports = new ApiMethod({
    name: 'suburbanWidgetSearchContext',
    params: {
        nationalVersion: {
            required: true,
        },
        clientSettlementId: {
            required: true,
        },
        searchForm: {
            required: true,
        },
    },
    action: ({nationalVersion, clientSettlementId, searchForm}, req) =>
        apiTimedGot(
            {
                ...apiConfig.options,
                path: `/${searchForm.language}/search/parse-context/`,
                query: {
                    nearest: 'true',
                    t_type: SUBURBAN_TYPE,
                    national_version: nationalVersion,
                    client_settlement_id: clientSettlementId,
                },
                json: true,
            },
            req,
            {
                operationName: '/:language/search/parse-context/',
            },
        ).then(({body}) => {
            const when = searchForm.when;
            const errors = (body.errors || []).map(error => {
                const key = Object.keys(error)[0];

                return {type: `${key}_${error[key]}`};
            });

            return {
                transportType: body.transportType,
                from: body.from,
                to: body.to,
                originalFrom: body.originalFrom,
                originalTo: body.originalTo,
                when,
                errors,
            };
        }),
});
