import {createApiMethod} from '../helpers/api';

module.exports = createApiMethod({
    name: 'teasers',
    params: {
        settlementId: {type: 'String', required: true},
        language: {type: 'String', required: true},
        nationalVersion: {type: 'String'},
    },
    buildPath: ({language, settlementId}) =>
        `/${language}/settlement/${settlementId}/teasers/`,
    buildOperationName: () => '/:language/settlement/:settlementId/teasers/',
    buildQuery: ({nationalVersion}) => ({national_version: nationalVersion}),
    defaultResponse: null,
});
