import {ApiMethod, ApiError} from 'bla';
import yaConfig from '@yandex-int/yandex-config';

import logger from '../logger';
import {apiTimedGot} from '../helpers/timedGot';
import requestIsFailed from './utils/requestIsFailed';

const {api: apiConfig} = yaConfig();

module.exports = new ApiMethod({
    name: 'thread2',
    params: {
        threadId: {
            type: 'String',
            required: true,
        },
        language: {
            type: 'String',
            required: true,
        },
        departure: {
            type: 'String',
        },
        departureFrom: {
            type: 'String',
        },
        stationFrom: {
            type: 'String',
        },
        stationTo: {
            type: 'String',
        },
        country: {
            type: 'String',
        },
        timezone: {
            type: 'String',
            defaultValue: '',
        },
        /** Флаг того что переход на страницу нитки был с поиска в город, а не станцию */
        isCitySearch: {
            type: 'Boolean',
            required: true,
        },
    },
    action: (
        {
            threadId,
            country,
            language,
            departure,
            departureFrom,
            stationFrom,
            stationTo,
            timezone,
            isCitySearch,
        },
        req,
    ) => {
        const query = {
            mixed_uid: threadId,
            country,
            departure,
            departure_from: departureFrom,
            station_from: stationFrom,
            station_to: stationTo,
            time_zone: timezone,
            busSettlementKeys: isCitySearch,
            disable_cancels: false /* Пока бэкенд возвращает отмены только с этим параметром для обратной совместимости */,
        };

        return apiTimedGot(
            {
                ...apiConfig.options,
                path: `/${language}/thread/`,
                query,
                json: true,
            },
            req,
            {
                operationName: '/:language/thread/',
            },
        )
            .then(({body}) => {
                if (requestIsFailed(body)) {
                    throw new ApiError(
                        null,
                        `Request failed: ${JSON.stringify(body)}`,
                    );
                }

                return body.result;
            })
            .catch(err => {
                logger.error('server/api/thread.js', err);

                throw err;
            });
    },
});
